% custombatch.m
% This script does repeated operations on a set of data files.
% Specifically, it takes all the existing relative measures of fluorescence
% and pulls out relative and absolute data sets, for a set of worms of the
% same condition (e.g. compiles data for 20 worms of unc-13).
%
% Please update the relevant fields to account for censored data, etc.


censoredList = [];
prefix = 'M1_nIs686_flicker';
mydate = '20150310_procorpus';
suffix = '.mat';
totalFiles = 20;
totalROIs = 1;


totalAbs = cell(1, totalROIs);
totalRel = cell(1, totalROIs);

first = true;
for i=1:totalFiles
    if (isempty(find(censoredList == i, 1)))
        num = i;
        if(i < 10)  % Prefix with a 0
            num = strcat('0', num2str(num));
        else
            num = num2str(num);
        end
        newpre = [prefix '_' num '_' mydate];
        load([newpre '' suffix]);
        eval(['[' newpre '_abs ' newpre '_rel] = updateNetFluorescence(rawfluorescence, fluorescenceBG);']);
        
        for j=1:totalROIs
            jstr = num2str(j);
            if (first)
                totalAbs{j} = eval([newpre '_abs(:,' jstr ')']);
                totalRel{j} = eval([newpre '_rel(:,' jstr ')']);
            else
                totalAbs{j} = cat(2, totalAbs{j}, eval([newpre '_abs(:,' jstr ')']'));
                totalRel{j} = cat(2, totalRel{j}, eval([newpre '_rel(:,' jstr ')']'));
            end
        end
        first = false;
    end
end

%rename each totalRel/totalAbs matrix to include date and genotype:
eval(['totalRel_' prefix '_' mydate, '=totalRel;'])
eval(['totalAbs_' prefix '_' mydate, '=totalAbs;'])

%save the dataset:

dataName=['data_' prefix '_' mydate]
totalAbs=['totalAbs_' prefix '_' mydate]
totalRel=['totalRel_' prefix '_' mydate]

save([dataName],[totalAbs], [totalRel])

%2015.01.20: What more do I (ss) want out of this program?
%1. Automatically label 'totalRel' and 'totalAbs' with specific data name.